#include "inifile.h"
#include "d3d.h"

IniFile g_iniFile;

//FIXME: SCREEN XPOS, YPOS, XSCALE, YSCALE should be floats!

IniFile::IniFile(void)
{
}

IniFile::~IniFile(void)
{
}

bool IniFile::Save(const string &szIniFileName)
{
	CSimpleIniA ini;
	SI_Error rc;
	ini.SetUnicode(true);
    ini.SetMultiKey(true);
    ini.SetMultiLine(false);
	ini.SetSpaces(true);

	//GENERAL SETTINGS
	//ini.SetBoolValue("GENERAL SETTINGS", "SHOW DEBUG INFO", m_currentIniEntry.bShowDebugInfo);
	
	//VIDEO SETTINGS
	ini.SetBoolValue("VIDEO SETTINGS", "bAutomaticFrameSkip", m_currentIniEntry.bAutomaticFrameSkip);
	ini.SetBoolValue("VIDEO SETTINGS", "bManualFrameSkip ", m_currentIniEntry.bManualFrameSkip);
	ini.SetLongValue("VIDEO SETTINGS", "dwNumFrameSkips", m_currentIniEntry.dwNumFrameSkips);
	ini.SetBoolValue("VIDEO SETTINGS", "bSyncAudioToVideo", m_currentIniEntry.bSyncAudioToVideo);
	ini.SetBoolValue("VIDEO SETTINGS", "bVSync", m_currentIniEntry.bVSync);
	ini.SetLongValue("VIDEO SETTINGS", "dwFlickerFilter", m_currentIniEntry.dwFlickerFilter);
	ini.SetBoolValue("VIDEO SETTINGS", "bSoftDisplayFilter", m_currentIniEntry.bSoftDisplayFilter);
	ini.SetLongValue("VIDEO SETTINGS", "dwTextureFilter", m_currentIniEntry.dwTextureFilter);
	ini.SetLongValue("VIDEO SETTINGS", "iXPOS", m_currentIniEntry.iXPOS);
	ini.SetLongValue("VIDEO SETTINGS", "iYPOS", m_currentIniEntry.iYPOS);
	ini.SetLongValue("VIDEO SETTINGS", "iXWIDTH", m_currentIniEntry.iXWIDTH);
	ini.SetLongValue("VIDEO SETTINGS", "iYHEIGHT", m_currentIniEntry.iYHEIGHT);
	ini.SetLongValue("VIDEO SETTINGS", "iResolution", m_currentIniEntry.iResolution);

	//EMULATOR SETTINGS
	ini.SetBoolValue("EMULATOR SETTINGS", "bHideNBG0", m_currentIniEntry.bHideNBG0);
	ini.SetBoolValue("EMULATOR SETTINGS", "bHideNBG1", m_currentIniEntry.bHideNBG1);
	ini.SetBoolValue("EMULATOR SETTINGS", "bHideNBG2", m_currentIniEntry.bHideNBG2);
	ini.SetBoolValue("EMULATOR SETTINGS", "bHideNBG3", m_currentIniEntry.bHideNBG3);
	ini.SetBoolValue("EMULATOR SETTINGS", "bHideRBG0", m_currentIniEntry.bHideRBG0);
	ini.SetBoolValue("EMULATOR SETTINGS", "bHideVDP1", m_currentIniEntry.bHideVDP1);


	rc = ini.SaveFile(szIniFileName.c_str());
	
	OutputDebugStringA(szIniFileName.c_str());

    if (rc < 0) 
	{
		OutputDebugStringA(" failed to save!\n");
		return false;
	}

	OutputDebugStringA(" saved successfully!\n");
	return true;
}

bool IniFile::Load(const string &szIniFileName)
{
CSimpleIniA ini;
SI_Error rc;
ini.SetUnicode(true);
ini.SetMultiKey(true);
ini.SetMultiLine(false);
ini.SetSpaces(true);

rc = ini.LoadFile(szIniFileName.c_str());

if (rc < 0) 
	{
		OutputDebugString("Failed to load ");
		OutputDebugString(szIniFileName.c_str());
		OutputDebugString("\n");
		return false;
	}

	OutputDebugStringA("Successfully loaded ");
	OutputDebugString(szIniFileName.c_str());
	OutputDebugString("\n");

	//GENERAL SETTINGS
	//m_currentIniEntry.bShowDebugInfo = ini.GetBoolValue("GENERAL SETTINGS", "SHOW DEBUG INFO", NULL );

	//VIDEO SETTINGS
	m_currentIniEntry.bAutomaticFrameSkip = ini.GetBoolValue("VIDEO SETTINGS", "bAutomaticFrameSkip", NULL );
	m_currentIniEntry.bManualFrameSkip = ini.GetBoolValue("VIDEO SETTINGS", "bManualFrameSkip ", NULL );
	m_currentIniEntry.dwNumFrameSkips = ini.GetLongValue("VIDEO SETTINGS", "dwNumFrameSkips", NULL );
	m_currentIniEntry.bSyncAudioToVideo = ini.GetBoolValue("VIDEO SETTINGS", "bSyncAudioToVideo", NULL );
	m_currentIniEntry.bVSync = ini.GetBoolValue("VIDEO SETTINGS", "bVSync", NULL );
	m_currentIniEntry.dwFlickerFilter  = ini.GetLongValue("VIDEO SETTINGS", "dwFlickerFilter", NULL );
	m_currentIniEntry.bSoftDisplayFilter = ini.GetBoolValue("GENERAL SETTINGS", "bSoftDisplayFilter", NULL );
	m_currentIniEntry.dwTextureFilter  = ini.GetLongValue("VIDEO SETTINGS", "dwTextureFilter", NULL );
	m_currentIniEntry.iXPOS  = ini.GetLongValue("VIDEO SETTINGS", "iXPOS", NULL );
	m_currentIniEntry.iYPOS  = ini.GetLongValue("VIDEO SETTINGS", "iYPOS", NULL );
	m_currentIniEntry.iXWIDTH  = ini.GetLongValue("VIDEO SETTINGS", "iXWIDTH", NULL );
	m_currentIniEntry.iYHEIGHT  = ini.GetLongValue("VIDEO SETTINGS", "iYHEIGHT", NULL );
	m_currentIniEntry.iResolution  = ini.GetLongValue("VIDEO SETTINGS", "iResolution", NULL );

	//EMULATOR SETTINGS
	m_currentIniEntry.bHideNBG0 = ini.GetBoolValue("EMULATOR SETTINGS", "bHideNBG0", NULL );
	m_currentIniEntry.bHideNBG1 = ini.GetBoolValue("EMULATOR SETTINGS", "bHideNBG1", NULL );
	m_currentIniEntry.bHideNBG2 = ini.GetBoolValue("EMULATOR SETTINGS", "bHideNBG2", NULL );
	m_currentIniEntry.bHideNBG3 = ini.GetBoolValue("EMULATOR SETTINGS", "bHideNBG3", NULL );
	m_currentIniEntry.bHideRBG0 = ini.GetBoolValue("EMULATOR SETTINGS", "bHideRBG0", NULL );
	m_currentIniEntry.bHideVDP1 = ini.GetBoolValue("EMULATOR SETTINGS", "bHideVDP1", NULL );
	
	return true;
}

bool IniFile::CreateAndSaveDefaultIniEntry()
{
	//GENERAL SETTINGS
	m_defaultIniEntry.bShowDebugInfo = false;

	//VIDEO SETTINGS
	m_defaultIniEntry.bAutomaticFrameSkip = true;
	m_defaultIniEntry.bManualFrameSkip = false;
	m_defaultIniEntry.dwNumFrameSkips = 3;
	m_defaultIniEntry.bSyncAudioToVideo = false;
	m_defaultIniEntry.bVSync = true;
	m_defaultIniEntry.dwFlickerFilter = 1;
	m_defaultIniEntry.bSoftDisplayFilter = false;
	m_defaultIniEntry.dwTextureFilter = 1; //1 = linear, 0 = point
	m_defaultIniEntry.iXPOS = 0;
	m_defaultIniEntry.iYPOS = 0;
	m_defaultIniEntry.iXWIDTH = 0;
	m_defaultIniEntry.iYHEIGHT = 0;
	m_defaultIniEntry.iResolution = RESOLUTION_MIN;

	//EMULATOR SETTINGS
	m_defaultIniEntry.bHideNBG0 = false;
	m_defaultIniEntry.bHideNBG1 = false;
	m_defaultIniEntry.bHideNBG2 = false;
	m_defaultIniEntry.bHideNBG3 = false;
	m_defaultIniEntry.bHideRBG0 = false;
	m_defaultIniEntry.bHideVDP1 = false;

	
	// our current ini is now the default ini
	m_currentIniEntry = m_defaultIniEntry;

	// save the default ini
	// FIXME! -> CD/DVD -> utility drive X:
	//Save("D:\\ybx.ini");
	//Temporary: do not save anything, rom ini is always in T:
	//and is generated by the launcher

return true;
}


bool IniFile::CheckForIniEntry()
{
	// try to load our ini file
	//if(!Load("D:\\ybx.ini"))
	if(!Load(szTempRomIniFileName))
	{
		// create a new one, if it doesn't exist
		CreateAndSaveDefaultIniEntry();
	}

return true;
}

bool IniFile::LoadTempRomFileName()
{
CSimpleIniA ini;
SI_Error rc;
ini.SetUnicode(true);
ini.SetMultiKey(true);
ini.SetMultiLine(true);

rc = ini.LoadFile("T:\\tmp.lce");

if (rc < 0) 
	{
		OutputDebugString("Failed to load T:\\tmp.lce\n");
		return false;
	}

szTempRomFileName = string(ini.GetValue("LAUNCHER", "ROM", ""));

szTempRomIniFileName = string(ini.GetValue("LAUNCHER", "INI", ""));

	// if need be, this will have the root dir for the system
	m_szTempSystemDir = string(ini.GetValue("LAUNCHER", "DIR", ""));

return true;
}




